using System;
using System.Diagnostics;
using System.IO;
using System.Runtime.InteropServices;
using System.Text;
using mshtml;
using System.Drawing;

namespace onlyconnect
{
	/// <summary>
	/// Summary description for utils.
	/// </summary>
	public class utils
	{
		public utils()
		{
			//
			// TODO: Add constructor logic here
			//
		}

		public static void LoadUrl(ref mshtml.HTMLDocument doc,String url)
		{
			
			if (doc == null)
			{
				throw new HtmlEditorException("Null document passed to LoadDocument");
			}
			
			//set client site to DownloadOnlySite, to suppress scripts

			DownloadOnlySite ds = new DownloadOnlySite();
			IOleObject ob = (IOleObject) doc;
			ob.SetClientSite(ds);
			
			IPersistMoniker persistMoniker = (IPersistMoniker) doc;

			UCOMIMoniker moniker = null;

			int iResult = ComSupport.CreateURLMoniker(null, url, out moniker);
	
			UCOMIBindCtx bindContext = null;
	
			iResult = ComSupport.CreateBindCtx(0, out bindContext);
	
			iResult = persistMoniker.Load(0, moniker, bindContext, ComSupport.STGM_READ);
			
			persistMoniker = null;
	
			bindContext = null;

			moniker = null;

		}

		public static void LoadDocument(ref mshtml.HTMLDocument doc, String documentVal)
		{
			
			if (doc == null)
			{
				throw new HtmlEditorException("Null document passed to LoadDocument");
			}

			bool mIsWin98 = (System.Environment.OSVersion.Platform == PlatformID.Win32Windows);
         
			Debug.WriteLine ("LoadDocument");
			
			if (documentVal == String.Empty)
			{
				documentVal = "<html></html>";
			}

			//set client site to DownloadOnlySite, to suppress scripts

			DownloadOnlySite ds = new DownloadOnlySite();
			IOleObject ob = (IOleObject) doc;
			ob.SetClientSite(ds);

			UCOMIStream stream = null;

			if (mIsWin98)
			{
				ComSupport.CreateStreamOnHGlobal(Marshal.StringToHGlobalAnsi(documentVal), 1, out
					stream);
			}
			else
			{
				ComSupport.CreateStreamOnHGlobal(Marshal.StringToHGlobalUni(documentVal), 1, out
					stream);
			}

			if (stream == null) 
			{
				throw new HtmlEditorException("Could not allocate document stream");
			}	

			
			if (mIsWin98)
			{
				//fix string termination on Win98
				ulong thesize = 0;
				IntPtr ptr = IntPtr.Zero;
	
				int iSizeOfInt64 = Marshal.SizeOf(typeof(Int64));
				ptr = Marshal.AllocHGlobal(iSizeOfInt64);

				if (ptr == IntPtr.Zero )
				{
					throw new HtmlEditorException("Could not load document");
				}
	
				//seek to end of stream
				stream.Seek(0,2,ptr );
				//read the size
				thesize = (ulong)Marshal.ReadInt64(ptr);
				//free the pointer
				Marshal.FreeHGlobal(ptr);
				// Debug.WriteLine("The size is: " + thesize.ToString());
	
				//truncate the stream
				stream.SetSize((long)thesize);

				//2nd param, 0 is beginning, 1 is current, 2 is end
   
				if (thesize != (ulong)documentVal.Length + 1)
				{
					//fix the size by truncating the stream
					Debug.Assert(true,"Size of stream is unexpected","The size of the stream is not equal to the length of the string passed to it.");
					stream.SetSize(documentVal.Length +1);
				}
  
			}

			//set stream to start

			stream.Seek(0,0,IntPtr.Zero);
			//2nd param, 0 is beginning, 1 is current, 2 is end
		
			IPersistStreamInit persistentStreamInit = (IPersistStreamInit)
				doc;
			if (persistentStreamInit != null)
			{
				persistentStreamInit.InitNew();
				persistentStreamInit.Load(stream);
				persistentStreamInit = null;
			}

			stream = null;

		}

		public static String GetDocumentSource(ref mshtml.HTMLDocument doc)
		{
			return GetDocumentSource(ref doc,EncodingType.WindowsCurrent);
		}

		public static String GetDocumentSource(ref mshtml.HTMLDocument doc, Encoding enc)
		{
			if (doc == null) return null;

			bool IsUnicodeDetermined = false;

			Encoding theEncoding = enc;
			if (theEncoding == null)
			{
				theEncoding = Encoding.GetEncoding(0);
				//Windows default
			}

			if (theEncoding != Encoding.GetEncoding(0))
			{
			//Don't try to detect unicode if we were
			//passed an encoding other than the default
			 IsUnicodeDetermined = true;				
			}

			// use the routine from htmlwrapper
			MemoryStream memstream = new MemoryStream();
			ComStream cstream = new ComStream(memstream);

			IPersistStreamInit pStreamInit = (IPersistStreamInit)doc;
			pStreamInit.Save( cstream, false );
		
			StringBuilder Result = new StringBuilder();
			
			//goto start of stream
			memstream.Seek(0, SeekOrigin.Begin);

			int iSize = 2048;
			byte[] bytedata = new byte[2048];
	
			while (true)
			{
				iSize = memstream.Read(bytedata, 0, bytedata.Length);
				if (iSize > 0) 
				{
					
					if (!IsUnicodeDetermined)
					{
						//look for byte order mark
						bool IsUnicode = false;
						if ((bytedata[0] == 0xFF) & (bytedata[1] == 0xFE))
						{
							IsUnicode = true;
						}

						if ((bytedata[0] == 0xFE) & (bytedata[1] == 0xFF))
						{
							IsUnicode = true;
						}

						//look for alternate zeroes

						if ((bytedata[1] == 0) & (bytedata[3] == 0) & (bytedata[5] == 0) & (bytedata[7] == 0))
						{
							IsUnicode = true;
						}

						if (IsUnicode) 
						{
							theEncoding = Encoding.Unicode;
						}

						//don't repeat the test
						IsUnicodeDetermined = true;
					}

					Result.Append (theEncoding.GetString(bytedata,0,iSize));
				}
				else
				{
					break;
				}
			}
			memstream.Close();
			
			return Result.ToString();
			
		}

		public static String GetDocumentSource(ref mshtml.HTMLDocument doc, EncodingType theDocumentEncoding)
		{
			Encoding theEncoding;

			switch (theDocumentEncoding)
			{
				case EncodingType.ASCII:
					theEncoding = new ASCIIEncoding();
					break;
				case EncodingType.Unicode:
					theEncoding = new UnicodeEncoding();
					break;
				case EncodingType.UTF7:
					theEncoding = new UTF7Encoding();
					break;
				case EncodingType.UTF8:
					theEncoding = new UTF8Encoding();
					break;
				case EncodingType.WindowsCurrent: 
					theEncoding = Encoding.GetEncoding(0);
					break;
				default:
					theEncoding = Encoding.GetEncoding(0);
					break;
			}

			return GetDocumentSource(ref doc,theEncoding);
		}
			
	}
	
}
